<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
	<?php
	include('../include/session.php');
	$date = $_GET['date'];
	include('../include/period_select_date.php');

	$table_name2 = $_SESSION['db_prefix'] . "_quotations";
	$quotation_query = "SELECT quote_no, status, cust_id, type, quotation_date, required_date, company_contact, contact_phone, project, project_no, seller, value, vat_text, priority FROM $table_name2 WHERE quotation_date BETWEEN ? AND ? ORDER BY quote_no DESC ";

	$stmt = $con->prepare($quotation_query);
	$stmt->bind_param("ss", $start, $end); // "ss" indicates two string parameters
	$start = $start;
	$end = $end;
	$stmt->execute();
	$result = $stmt->get_result();
	$quotation_result = $result->fetch_all(MYSQLI_ASSOC);
	$quotation_num = count($quotation_result);
	?>
	<!--style sheets-->
	<link rel="stylesheet" type="text/css" href="../css/tooltip.css" />
	<link rel="stylesheet" type="text/css" href="../css/scroll_table.css" />

<body>
	<?php
	$_SESSION['current_page']  = "sales";
	include("../navigation/header.php");
	$page_name = "Sales-main";
	include("../navigation/access.php");
	if ($permission_num == 1) {
		include("../navigation/sales_sidebar.php");
	?>
		<div class="main_frame">
			<div class="page_head_frame">
				<table width="809" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td width="385"><label class="label_page_head">Sales quotations</label></td>
						<td width="253">&nbsp;</td>
						<td width="171" align="right">&nbsp;</td>
					</tr>
				</table>
			</div>
			<div class="page_middle_frame">
				<?php
				$page = 'sales_main.php';
				$reference_name = '';
				$reference = '';
				include('../include/period_select_block.php');
				?>
				<div class="page_inside_frame">
					<div align="left">
						<label class="label_end"><img src="../images/round_green.png" width="8" height="8" />: success&nbsp;&nbsp;<img src="../images/round_orange.png" width="8" height="8" />: pending&nbsp;&nbsp;<img src="../images/round_red.png" width="8" height="8" />:unsuccessful</label>
						&nbsp;&nbsp;&nbsp;&nbsp;
						<label class="label_end">&nbsp;<img src="../images/flame_red.png" alt="" width="16" height="16" />: hot&nbsp;&nbsp;<img src="../images/flame_orange.png" alt="" width="16" height="16" />: Warm&nbsp;&nbsp;<img src="../images/flame_blue.png" alt="" width="16" height="16" />: cold</label>
					</div>
					<!--jscript-->
					<script language="javascript" src="../jscript/calendar.js"></script>
					<script language="JavaScript" src="../jscript/tooltip.js" type="text/javascript"></script>
					<script type="text/javascript" language="javascript" src="../jscript/jquery.dataTables.js"></script>
					<script type="text/javascript" charset="utf-8">
						$(document).ready(function() {
							$('#scroll_table').dataTable({
								"sScrollY": "500px",
								"bPaginate": false,
								"bScrollCollapse": true,
								"aaSorting": [
									[1, "desc"]
								],
								"aoColumns": [{
										"bSortable": false
									},
									{
										"bSortable": false
									},
									{
										"bSortable": true
									},
									{
										"iDataSort": 10
									},
									{
										"bSortable": true
									},
									{
										"bSortable": true
									},
									{
										"bSortable": true
									},
									{
										"bSortable": true
									},
									{
										"bSortable": true
									},
									{
										"bSortable": true
									},
									{
										"bVisible": false
									}
								]
							});
						});
					</script>
					<table width="909" id="scroll_table" class="data_display">
						<thead>
							<tr>
								<th align="center">&nbsp;</th>
								<th>&nbsp;</th>
								<th>Number</th>
								<th>Date</th>
								<th>Project</th>
								<th>Project no</th>
								<th>Name</th>
								<th>Contact</th>
								<th>Value</th>
								<th>Sales rep</th>
								<th>&nbsp;</th>
							</tr>
						</thead>
						<?php
						$i = 0;
						$a7tot = 0;
						while ($i < $quotation_num) {
							$a1 = mysqli_fetch_assoc($quotation_result)["quote_no"];

							$a2 = mysqli_fetch_assoc($quotation_result)["cust_id"];
							if ($a2 == 0) {
								$a2a = 'Bill of quantity';
								$a2b = '';
								$a2c = '';
								$a2d = '';
								$a2e = '';
								$a2f = '';
								$a3 = '';
							} else {
								$table_name3 = $_SESSION['db_prefix'] . "_customer";
								$customer_query = "SELECT comp_name, status, bag_box, box_no, postal_place, phone, contact_1 FROM $table_name3 WHERE cust_id = ?";
								$customer_stmt = $con->prepare($customer_query);
								$customer_stmt->bind_param("i", $a2);
								$customer_stmt->execute();
								$customer_result = $customer_stmt->get_result();
								$customer_row = $customer_result->fetch_assoc();

								$a2a = $customer_row["comp_name"];
								$a2b = $customer_row["bag_box"];
								$a2c = $customer_row["box_no"];
								$a2d = $customer_row["postal_place"];
								$a2e = $customer_row["phone"];
								$a2f = $customer_row["contact_1"];
								$a3 = $customer_row["status"];
							}

							$a5 = mysqli_fetch_assoc($quotation_result)["quotation_date"];
							$a6 = mysqli_fetch_assoc($quotation_result)["required_date"];
							$a7 = mysqli_fetch_assoc($quotation_result)["value"];
							$a8 = mysqli_fetch_assoc($quotation_result)["seller"];
							$a9 = mysqli_fetch_assoc($quotation_result)["company_contact"];
							$a10 = mysqli_fetch_assoc($quotation_result)["contact_phone"];
							$a11 = mysqli_fetch_assoc($quotation_result)["status"];
							$a12 = mysqli_fetch_assoc($quotation_result)["project_no"];
							$a13 = mysqli_fetch_assoc($quotation_result)["project"];
							$a16 = mysqli_fetch_assoc($quotation_result)["vat_text"];
							$a17 = mysqli_fetch_assoc($quotation_result)["priority"];

							$table_name = $_SESSION['db_prefix'] . "_quotation_lines";
							$line_query = "SELECT quote_item_text, quote_item_price FROM $table_name WHERE quote_number = ?";
							$line_stmt = $con->prepare($line_query);
							$line_stmt->bind_param("s", $a1);
							$line_stmt->execute();
							$line_result = $line_stmt->get_result();
							$line_num = $line_result->num_rows;

							// Query for retrieving line items
							$l = 0;
							$line_text = '';
							$line_query = "SELECT quote_item_price, quote_item_text FROM line_table WHERE quote_number = ?";
							$line_stmt = mysqli_prepare($con, $line_query);
							mysqli_stmt_bind_param($line_stmt, "s", $a1);
							mysqli_stmt_execute($line_stmt);
							$line_result = mysqli_stmt_get_result($line_stmt);
							while ($row = mysqli_fetch_assoc($line_result)) {
								$price = $row['quote_item_price'];
								$line = $row['quote_item_text'];
								$line_text .= "&nbsp;-&nbsp;" . $line . " @ P " . number_format($price, 2, '.', ',') . "<br>";
								$l++;
							}
							mysqli_stmt_close($line_stmt);
							// Query for retrieving notes
							$m = 0;
							$notes_text = '';
							$notes_query = "SELECT note_date, note_text, seller FROM notes_table WHERE quote_number = ? ORDER BY note_date DESC";
							$notes_stmt = mysqli_prepare($con, $notes_query);
							mysqli_stmt_bind_param($notes_stmt, "s", $a1);
							mysqli_stmt_execute($notes_stmt);
							$notes_result = mysqli_stmt_get_result($notes_stmt);
							while ($row = mysqli_fetch_assoc($notes_result)) {
								$notes1 = date("d-m-Y", strtotime($row['note_date'])) . " " . $row['seller'] . ": ";
								$notes2 = $row['note_text'];
								$notes_text .= '<tr><td valign=top>' . $notes1 . '</td><td valign=top>' . $notes2 . '</td><tr>';
								$m++;
							}
							mysqli_stmt_close($notes_stmt);
							// Build the quote tooltip
							$quoteTT = "<table id=table_tool_tip width=450 ><tr><td  width=75>Quote no:</td><td width=175>" . $a1 . "</td></tr></tr><tr><td valign=top>Items quoted:</td><td valign=top>" . $line_text . "</td></tr><tr><td valign=top>Total quote value:</td><td valign=top>P" . number_format($a7, 2, '.', ',') . "</td></tr><tr><td>Notes:</td><td>" . $notes_text . "</td></tr></table><br><b>Click for details</b>";
							// Build the products tooltip
							$productsTT = "<table id=table_tool_tip width=250 ><tr><td  width=75>Products quoted:</td><td width=175>" . $line_text . "</td></tr></table><br><b>Click for details</b>";
							// Build the customer tooltip
							$customerTT = "<table id=table_tool_tip width=250 ><tr><td  width=75>Company:</td><td width=175>" . $a2a . "</td></tr><tr><td>Address:</td><td>" . $a2b . "&nbsp;" . $a2c . "<br>" . $a2d . "</td></tr><tr><td>Phone:</td><td>" . $a2e . "</td></tr><tr><td>Contact:</td><td>" . $a2f . "</td></tr></table><br><b>Click for details</b>";
						?>
							<tr>
								<td width="28" align="center"><?php if ($a11 == "quoted") { ?>
										<img src="../images/round_orange.png" width="12" height="12" />
									<?php } ?>
									<?php if ($a11 == "accepted") { ?>
										<img src="../images/round_green.png" width="12" height="12" />
									<?php } ?>
									<?php if ($a11 == "unsuccessful") { ?>
										<img src="../images/round_red.png" width="12" height="12" />
									<?php } ?>
								</td>
								<td width="36" style="padding-left:0px;" align="center">
									<?php if ($a17 == "Hot") { ?>
										<img src="../images/flame_red.png" width="16" height="16" />
									<?php } ?>
									<?php if ($a17 == "Warm") { ?>
										<img src="../images/flame_orange.png" width="16" height="16" />
									<?php } ?>
									<?php if ($a17 == "Cold") { ?>
										<img src="../images/flame_blue.png" width="16" height="16" />
									<?php } ?>
								</td>
								<td width="95" style="padding-left:0px;" align="left">
									<?php if ($a2 == 0) { ?>
										<a href="qbill.php?quote_no=<?php echo $a1 ?> " onMouseover="ddrivetip('Bill of quantity', 100)" ; onMouseout="hideddrivetip()"><?php echo $a1 ?></a>
									<?php } else { ?>
										<a href="quotation.php?quote_no=<?php echo $a1 ?> " onMouseover="ddrivetip('<?php echo $quoteTT ?> ', 450)" ; onMouseout="hideddrivetip()"><?php echo $a1 ?></a>
									<?php } ?>
								</td>
								<td width="68" align="left"><?php echo date("d-m-Y", strtotime($a5)) ?></td>
								<td width="114" align="left"><?php echo $a13 ?></td>
								<td width="78" align="left"><?php echo $a12 ?>&nbsp;</td>
								<td width="124" align="left"><?php if ($a2 == 0) {
																	echo $a2a;
																} else { ?> <a href="customer_details.php?cust_id=<?php echo $a2 ?>" onmouseover="ddrivetip('<?php echo $customerTT ?>', 250)" ; onmouseout="hideddrivetip()"><?php echo $a2a ?></a><?php } ?></td>
								<td width="102" align="left"><?php echo $a9 . "<br>" . $a10 ?>&nbsp;</td>
								<td width="63" align="right"><?php if ($a16 == 'inclusive') {
																	$a7 = $a7 / 1.12;
																	echo '*&nbsp;&nbsp;';
																}
																echo number_format($a7, 2, '.', ',') ?></td>
								<td width="111" align="left"><?php echo $a8 ?>&nbsp;</td>
								<td width="42" align="left"><?php echo $a5 ?>&nbsp;</td>
							</tr>
						<?php
							$i++;
						}
						?>
						<tfoot>
							<tr style="border-top-style:double;">
								<td colspan="8" align="right">Total:</td>
								<td align="right"><?php echo number_format($a7tot, 2, '.', ',') ?></td>
								<td colspan="2" align="right">&nbsp;</td>
							</tr>
						</tfoot>
					</table>
					<div align="left"><label class="label_end">end of list</label></div>
				</div>
			</div>
		</div>
</body>
<?php } else {
		$_SESSION['denied_return'] = $_SESSION['location'];
		include("../navigation/sales_sidebar.php"); ?>

	<body onload="accessdenied(); return false">
	</body>
<?php }
?>
<?php include('../navigation/side_bar.php'); ?>

</html>