<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
  <?php
  include('../include/session.php');
  $a2a = "";
  $a2b = "";
  $a2c = "";
  $a2d = "";
  $a2e = "";
  $a2f = "";
  $a3 = "";
  $table_name = $_SESSION['db_prefix'] . "_maintenance_jobs";
  $job_query = "SELECT * FROM $table_name WHERE invoiced = ? AND completed IS NULL ORDER BY maintenance_card_no DESC";
  $stmt = $con->prepare($job_query);
  $stmt->bind_param("s", $invoiced); // Assuming $invoiced is the value for the "invoiced" parameter
  $invoiced = 'yes';
  $stmt->execute();
  $job_result = $stmt->get_result();
  $job_num = $job_result->num_rows;

  ?>
  <!--style sheets-->
  <link href="../css/main.css" rel="stylesheet" type="text/css" />
  <link rel="stylesheet" type="text/css" href="../css/tooltip.css" />
  <!--jscript-->
  <script language="JavaScript" src="../jscript/tooltip.js" type="text/javascript"></script>
</head>

<body>
  <?php
  include("../navigation/header.php");
  $page_name = "Maintenance-main";
  include("../navigation/access.php");

  if ($permission_num == 1) {
    include("../navigation/maintenance_sidebar.php");
  ?>
    <div class="main_frame">
      <div class="page_head_frame">
        <table width="600" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td width="385"><label class="label_page_head">Maintenance</label></td>
            <td align="right">&nbsp;</td>
          </tr>
        </table>
      </div><br />
      <div class="scroll_frame_long" style="height:450px; width:700px;">
        <table width="680" id="table_list" class="sortable-onload-1r rowstyle-alt no-arrow ">
          <thead>
            <tr>
              <th width="87" align="center">Maintenance<br>
                card</th>
              <th width="115" align="left" class="sortable-date-dmy">Project</th>
              <th width="58" align="center" class="sortable-date-dmy">Start<br>
                Date</th>
              <th width="134" align="left" class="sortable-text">Customer</th>
              <th width="101" align="center">Open<br>
                Maintenance<br>
                card</th>
              <th width="87" align="center">Close<br>
                Maintenance<br>
                card</th>
              <th width="66" align="center">Complete</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $i = 0;
            $amount = 0;
            while ($row_job = mysqli_fetch_array($job_result)) {
              $b0 = $row_job["maintenance_no"];
              $b0a = $row_job["maintenance_card_no"];
              $b1 = $row_job["cust_id"];

              $table_name3 = $_SESSION['db_prefix'] . "_customer";
              $customer_query = "SELECT comp_name, name_2, title, account_type, status, bag_box, box_no, postal_place, phone, contact_1 FROM $table_name3 WHERE cust_id = ?";
              $stmt1 = $con->prepare($customer_query);
              $stmt1->bind_param("s", $b1); // "s" indicates a string parameter, replace with appropriate type if needed
              $stmt1->execute();
              $customer_result = $stmt1->get_result();
              $customer_num = $customer_result->num_rows;

              if ($customer_num != 0) {
                $row_customer = $customer_result->fetch_assoc();
                $type = $row_customer["account_type"];

                if ($type == "corporate") {
                  $a2a = $row_customer["comp_name"];
                } else {
                  $a2a = $row_customer["title"] . " " . $row_customer["name_2"] . " " . $row_customer["comp_name"];
                }

                $a2b = $row_customer["bag_box"];
                $a2c = $row_customer["box_no"];
                $a2d = $row_customer["postal_place"];
                $a2e = $row_customer["phone"];
                $a2f = $row_customer["contact_1"];
                $a3 = $row_customer["status"];
              }

              $table_name = $_SESSION['db_prefix'] . "_maintenance_jobs";
              $project_query = "SELECT start_date, project, project_no, project_place, project_description FROM $table_name WHERE maintenance_no = ?";
              $stmt2 = $con->prepare($project_query);
              $stmt2->bind_param("s", $b0); // "s" indicates a string parameter, replace with appropriate type if needed
              $stmt2->execute();
              $project_result = $stmt2->get_result();
              $row_project = $project_result->fetch_assoc();

              $b2 = $row_project["start_date"];
              $project = $row_project["project"];
              $b9 = $row_project["project_no"];
              $b10 = $row_project["project_place"];
              $b11 = $row_project["project_description"];

              $b13 = $row_job["value"];
              $b20 = $row_job["quotation"];
              $b21 = $row_job["invoiced"];
              $b22 = $row_job["card_opened"];
              $b23 = $row_job["card_closed"];
              $b24 = $row_job["completed"];

              $jobTT = "<table id=table_tool_tip width=300 ><tr><td  width=100>Job no:</td><td width=175>" . $b0a . " (" . $b0 . ")</td></tr><tr><td valign=top>Project no /place:</td><td>" . $b9 . "&nbsp;" . $b10 . "</td></tr><tr><td>Project:</td><td>" . $project . "</td></tr><tr><td>Project description:</td><td>" . $b11 . "</td></tr><tr><td>Job value:</td><td>P " . $b13 . " </td></tr><tr><td>Date:</td><td>" . date("d-m-Y", strtotime($b2)) . "</td></tr></table><br><b>Click for details</b>";
              $customerTT = "<table id=table_tool_tip width=250 ><tr><td  width=75>Company:</td><td width=175>" . $a2a . "</td></tr><tr><td>Address:</td><td>" . $a2b . "&nbsp;" . $a2c . "<br>" . $a2d . "</td></tr><tr><td>Phone:</td><td>" . $a2e . "</td></tr><tr><td>Contact:</td><td>" . $a2f . "</td></tr></table><br><b>Click for details</b>";
            ?>
              <tr class="alt">
                <td align="center" style="padding-left:0px;"><a href="maintenance_card.php?maintenance_card_no=<?php echo $b0a; ?>" onMouseOver="ddrivetip('<?php echo $jobTT ?>', 300)" ; onMouseOut="hideddrivetip()" target="_parent"><?php echo $b0a; ?></a></td>
                <td><span style="padding-left:0px;"><a href="maintenance_card.php?maintenance_card_no=<?php echo $b0a; ?>" onMouseOver="ddrivetip('<?php echo $jobTT; ?>', 300)" ; onMouseOut="hideddrivetip()" target="_parent"><?php echo $project; ?></a></span></td>
                <td><?php if ($b2 != '') {
                      echo date("d-m-Y", strtotime($b2));
                    } ?></td>
                <td align="left"><a href="../sales/customer_details.php?cust_id=<?php echo $b1; ?>" onmouseover="ddrivetip('<?php echo $customerTT; ?>', 250)" ; onmouseout="hideddrivetip()"><?php echo $a2a; ?></a></td>
                <td align="center"><?php
                                    if ($b21 == 'yes') {
                                      if ($b22 == 'yes') { ?>
                      <a href="maintenance_card.php?maintenance_card_no=<?php echo $b0a; ?>" onmouseover="ddrivetip('Maintenance card opened', 150)" ; onmouseout="hideddrivetip()"><img src="../images/round_green.png" alt="" width="12" height="12"></a>
                    <?php } ?>
                    <?php if ($b22 == '') { ?>
                      <a href="maintenance_compileJobWiz0.php?maintenance_no=<?php echo $b0; ?>" onmouseover="ddrivetip('Click to open maintenance card', 150)" ; onmouseout="hideddrivetip()"><img src="../images/round_red.png" alt="" width="12" height="12"></a>
                  <?php }
                                    } ?>
                </td>
                <td align="center"><?php

                                    if ($b22 == 'yes') {
                                      if ($b23 == 'yes') { ?>
                      <a href="closed_maintenance_card.php?maintenance_card_no=<?php echo $b0a; ?>" onmouseover="ddrivetip('Maintenance card closed', 150)" ; onmouseout="hideddrivetip()"><img src="../images/round_green.png" alt="" width="12" height="12"></a>
                    <?php } ?>
                    <?php if ($b23 == '') { ?>
                      <a href="maintenance_closeJobWiz0.php?maintenance_card_no=<?php echo $b0a; ?>" onmouseover="ddrivetip('Click to close maintenance card', 150)" ; onmouseout="hideddrivetip()"><img src="../images/round_red.png" alt="" width="12" height="12"></a>
                    <?php } ?>
                  <?php }
                  ?>
                </td>
                <td align="center"><?php
                                    if (($b23 == 'yes')) {
                                      if ($b24 == 'yes') { ?>
                      <a href="../orders/invoice_report_list.php?date=" onmouseover="ddrivetip('Job completed', 150)" ; onmouseout="hideddrivetip()"><img src="../images/round_green.png" alt="" width="12" height="12"></a>
                    <?php } else { ?>
                      <a href="maintenance_completeJobWiz0.php?maintenance_card_no=<?php echo $b0a; ?>" onmouseover="ddrivetip('Click to complete maintenance job', 175)" ; onmouseout="hideddrivetip()"><img src="../images/round_red.png" alt="" width="12" height="12"></a>
                  <?php }
                                    } ?>
                </td>
              </tr>
            <?php
              $i++;
            } ?>
          </tbody>
        </table>
      </div>

    </div>
</body>



<?php } else {
    $_SESSION['denied_return'] = $_SESSION['location'];
    include("../navigation/maintenance_sidebar.php"); ?>

  <body onload="accessdenied(); return false">
  </body>
<?php }
?>

<?php include('../navigation/side_bar.php'); ?>

</html>